 ; Ŀ
 ;   Squish - If text is over a certain real width, make it narrower.      
 ;   Copyright 1995, 2002 by Rocket Software Ltd.                          
 ;   Rocket - the Ride of the Valkyries of programming.                    
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of a text entity.                    
 ;   Takes one argument: the text entity data list.  Returns a width.      
 ; 
 (DEFUN WITS (entt / tblist cc dd)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (- (car dd) (car cc)))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine vice - squeeze or stretch text as required.                
 ;   Takes two arguments: a text ename and desired width.                  
 ; 
 (DEFUN VICE (enam width / txtscl entt realwd widscl prev41 scalfc)
  (setq txtscl 1.0)   ; set the desired text width scale
 ; Ŀ
 ;   Get the text entity data.                                             
 ; 
  (setq entt (entget enam))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
  (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
  (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ; 
  (if (and (> realwd width) (not (equal realwd width 0.1)))
 ; Ŀ
 ;   If the actual width is greater than the allowed width in the          
 ;   sublist, then adjust the width scale factor to make it fit.           
 ;   Wait: must also check to see if the width scale is greater than the   
 ;   ideal - if the attribute is too wide and the width scale is too       
 ;   large, then shrinking the attribute to fit may result in it just      
 ;   filling the space but still being too wide.                           
 ; 
      (progn
 ; Ŀ
 ;   Compare the actual width scale to the ideal width scale.              
 ; 
           (if (<= widscl txtscl)
 ; Ŀ
 ;   If the actual is less than or equal to the ideal, then make it fit.   
 ; 
               (progn
                    (setq scalfc (/ width realwd))
                    (setq widscl (* widscl scalfc))
                    (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   If the actual width scale is greater than the ideal, see if the       
 ;   attribute will be too wide if if set to the ideal.                    
 ;   If so then squash to fit, if not then set to the ideal.               
 ; 
               (progn
                    (if (> (* realwd (/ txtscl widscl)) width)
 ; Ŀ
 ;   Squash to fit.                                                        
 ; 
                        (progn
                             (setq scalfc (/ width realwd))
                             (setq widscl (* widscl scalfc))
                             (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Set to the ideal width scale factor.                                  
 ; 
                        (entmod (subst (cons 41 txtscl) prev41 entt))))))
 ; Ŀ
 ;   Else the actual width is narrower than or equal to the available      
 ;   space.                                                                
 ; 
      (progn
 ; Ŀ
 ;   See if the attribute is narrower than it should be - if setting the   
 ;   width scale factor to the desired value would leave the attribute     
 ;   wider than the allowable space, then increase it to fill the space.   
 ; 
           (if (> (* realwd (/ txtscl widscl)) width)
               (progn
                    (setq scalfc (/ width realwd))
                    (setq widscl (* widscl scalfc))
                    (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
               (entmod (subst (cons 41 txtscl) prev41 entt)))))
 (princ))
 ; Ŀ
 ;   Vice end.                                                             
 ; 

 ; Ŀ
 ;   Squish.                                                               
 ; 
 (DEFUN C:SQUISH (/ ss num width enam entt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (prompt "Select text to squish: ")
  (if (setq ss (ssget (list (cons 0 "TEXT"))))
      (progn
           (setq num 0)
           (setq width (getdist "Desired text width: "))
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (vice enam width))))
  (command "undo" "end")
 (princ))